import pandas as pd  
from sklearn.preprocessing import StandardScaler, LabelEncoder  
from sklearn.cluster import KMeans  
import pickle
from decision_company import read_csv_file, col_copy, create_standard_scaler, fit_transform_standard_scaler, create_label_encoder, fit_transform_label_encoder, get_dummies, create_kmeans, fit_predict_kmeans, col_assign_val, fetch_column
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Extract the important columns  
important_columns = ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status']  
data_for_clustering = col_copy(credit_customers, important_columns)  
  
# Preprocess the data  
le_savings_status = create_label_encoder()  
le_employment = create_label_encoder()  
col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(le_savings_status, data_for_clustering['savings_status']))
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(le_employment, data_for_clustering['employment']))
data_for_clustering = get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)  
  
# Normalize the data  
scaler = create_standard_scaler()  
data_for_clustering_scaled = fit_transform_standard_scaler(scaler, data_for_clustering)  
  
# Perform K-means clustering  
kmeans = create_kmeans(n_clusters=4, random_state=42)  
cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  
  
# Add the cluster labels to the original dataset  
col_assign_val(credit_customers, 'cluster', cluster_labels)
  
# Return the clustering algorithm used, parameters chosen, and resulting customer segments  
result = ("K-means", {"n_clusters": 4, "random_state": 42}, fetch_column(credit_customers, ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status', 'cluster']))
print("result:\n", result)